/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQuick module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QUICKDESIGNERCUSTOMPARSEROBJECT_H
#define QUICKDESIGNERCUSTOMPARSEROBJECT_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API. It exists purely as an
// implementation detail. This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QObject>
#include <private/qqmlcustomparser_p.h>

QT_BEGIN_NAMESPACE

class QQuickDesignerCustomParserObject : public QObject
{
    Q_OBJECT

public:
    QQuickDesignerCustomParserObject();
};

class QQuickDesignerCustomParser : public QQmlCustomParser
{
public:
    QQuickDesignerCustomParser()
    : QQmlCustomParser(AcceptsAttachedProperties | AcceptsSignalHandlers) {}

    void verifyBindings(const QQmlRefPointer<QV4::ExecutableCompilationUnit> &compilationUnit, const QList<const QV4::CompiledData::Binding *> &props) override;
    void applyBindings(QObject *obj, const QQmlRefPointer<QV4::ExecutableCompilationUnit> &compilationUnit, const QList<const QV4::CompiledData::Binding *> &bindings) override;
};

QT_END_NAMESPACE

#endif // QUICKDESIGNERCUSTOMPARSEROBJECT_H
